<?php
    require_once('../refactoring.php');

    $error = array();
    $title = '';
    $author= '';
    $content='';

    if(isset($_POST['add-post'])){
        //la gestions des erreurs sur les valeurs des champs du formulaire
        $error = validatePost($_POST);

        //traitement de l'image
        if(!empty($_FILES['image']['name'])){
            //pour eviter le confulit de donnée on met la fonction date() pour faire la 
            //difference de l'enregistrement d'une image
            $image_name =  date('d-M-Y').'-'.$_FILES['image']['name'];
            $destination=  "../images/$image_name";
            
            $result=   move_uploaded_file($_FILES['image']['tmp_name'],$destination);
            if($result){
                $_POST['image'] = $image_name;
            }else{
                array_push($error, 'l\'enregistrement de l\'image a echoué');
            }
        }else{
            array_push($error,'une image est demandé');
        }
        if(count($error) == 0){
            $_POST['content'] = nl2br(htmlentities($_POST['content']));
            
            //enregistrement de l'article dans la base de donnée
            create($_POST['author'],$_POST['title'],$_POST['content'],$_POST['image']);
            header('location: index.php');
            exit();
        }else{
            $title = $_POST['title'];
            $author = $_POST['author'];
            $content = $_POST['content'];
        }
    }
?>
<!DOCTYPE html>
<html lang="fr">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">

        <!-- Custom Styling -->
        <link rel="stylesheet" href="../css/style.css">

        <!-- Admin Styling -->
        <link rel="stylesheet" href="../css/admin.css">

        <title>Admin Section - Add Post</title>
    </head>

    <body>
        <!-- Debut header -->
            <?php include('../inc/header.php') ?>
        <!-- Fin header -->

        <!-- Admin Page Wrapper -->
        <div class="admin-container">

        
            <!-- // Left Sidebar -->


            <!-- Admin Content -->
            <div class="admin-content">
                <div class="button-group">
                    <a href="create.php" class="btn btn-big">Ajout d'un article</a>
                    <a href="index.php" class="btn btn-big">Gérer des articles</a>
                </div>


                <div class="container">

                    <h2 class="page-title">Ajouter des articles</h2>

                    <!--include le fichier pour afficher les error-->
                    <?php include('fromerror.php');?>
                    <form action="create.php" enctype="multipart/form-data" method="post">
                        <div>
                            <label>Author</label>
                            <input type="text" name="author"  class="text-input" value="<?= $author;?>">
                        </div>
                        <div>
                            <label>Title</label>
                            <input type="text" name="title"  class="text-input" value="<?= $title;?>">
                        </div>
                        <div>
                            <label>Contenu</label><br>
                            <textarea cols="130", rows="10" name="content" id="body"><?= $content;?></textarea>
                        </div>
                        <div>
                            <label>Image</label>
                            <input type="file" name="image"  class="text-input">
                        </div>
                        
                        <div>
                            <button type="submit" name="add-post" class="btn btn-big">Ajouter l'article</button>
                        </div>
                    </form>

                </div>

            </div>
            <!-- // Admin Content -->

        </div>
        <!-- // Page Wrapper -->
     <!-- Debut footer -->
       <?php include('../inc/footer.php') ?>
     <!-- Fin footer -->

    </body>

</html>