<?php
    require_once ('db.php');
//validation d'un article d'ajout

    function validatePost($post){
        $error = array();
        if(empty($post['author'])){
            array_push($error, "veillez entrer votre Nom");
        }
        if(empty($post['title'])){
            array_push($error, "veillez mettre le titre de l'article");
        }
        if(empty($post['content'])){
            array_push($error, "veillez écrire le contenu de l'article");
        }
        return $error;
    }
//function qui récupers tous les articles de ma base


    function selectAll($noPage,$perPage){
      global $pdo;
      $results = $pdo->query('SELECT * FROM posts ORDER BY 
      created_at ASC LIMIT '.($perPage*($noPage-1)).','.$perPage);
      $posts  = $results->fetchALL(); 
      return $posts;
    }

//récuperation d' un et un seul article grâce à son id pour afficher dans la page single
    function selectOne($id){
        global $pdo;
        $query = $pdo->prepare('SELECT * FROM posts WHERE id = :post_id');
        $query->execute(array('post_id'=>$id));
        $post = $query->fetch();
        return $post;
    }
//Selection de tous les articles pour les pagination
    function pagination(){
        global $pdo;
        $query = $pdo->prepare('SELECT COUNT(*) as nbr_articles FROM posts');
        $query->execute([]);
        $nombre = $query->fetch();
        return $nombre['nbr_articles'];
    }
//enregistrement d'un article dans la base de donnée
    function create($author, $title, $content, $image){
        global $pdo;
        $query = $pdo->prepare('INSERT INTO posts(author,title,content,image,created_at)
        VALUES (:auteur,:titre,:contenu,:image,Now())');
        $query->execute([
            'auteur'=>$author,
            'titre'=>$title,
            'contenu'=>$content,
            'image'=>$image,
        ]);
    }

//modifier un article dans la base de donnée

    function updatePost($id,$author,$title,$content,$image){
        global $pdo;
        $query= $pdo->prepare('UPDATE posts SET author=:auteur, title=:titre, content=:contenu,
        image=:image WHERE id=:id');
        $query->execute([
            'auteur'=>$author,
            'titre' =>$title,
            'contenu'=>$content,
            'image' =>$image,
            'id'=>$id,
        ]);
    }
//supprimer un article dans la base de donnée

    function deletePost($id){
        global $pdo;
        $query = $pdo->prepare('DELETE FROM posts WHERE id=:id');
        $query->execute(['id'=>$id]);
    }

//sauvegarder un commentaire de l' article dans la base de donnée
    function saveComment($auteur,$post_id,$comment){
        global $pdo;
        $query = $pdo->prepare('INSERT INTO comments(id_post,auteur,comment,created_at)
        VALUES(:id_post,:auteur,:comment, NOW())');
        $query->execute([
            'id_post'=>$post_id,
            'auteur'=>$auteur,
            'comment'=>$comment,
        ]);
    }

//récuperation d' un commentaire de l' article dans la base de donnée
    function findAllComments($id_post){
        global $pdo;
        $query = $pdo->prepare('SELECT * FROM comments WHERE id_post= :post_id ORDER BY created_at DESC');
        $query->execute(['post_id'=>$id_post]);
        
        $comments = $query->fetchAll();
        return $comments;
    }


?>