<!doctype html>
<html lang="en">
<head>
    <?php include 'include/head.php' ?>
    <title>Connexion</title>
</head>
<body>
<?php include 'include/nav.php' ?>
<div class="container py-2">
    <?php
        if (isset($_POST['connexion'])) {
            $login = $_POST['login'];
            $pwd   = $_POST['password'];

            if (!empty($login) && !empty($pwd)) {
                require_once 'include/database.php';

                // On récupère l'utilisateur par son login uniquement
                $sqlState = $pdo->prepare('SELECT * FROM utilisateur WHERE login = ?');
                $sqlState->execute([$login]);

                if ($sqlState->rowCount() >= 1) {
                    $user = $sqlState->fetch();

                    //  Vérification du mot de passe haché avec password_verify()
                    if (password_verify($pwd, $user['password'])) {
                        $_SESSION['utilisateur'] = $user;
                        header('location: admin.php');
                    } else {
                        //  Mot de passe incorrect
                        echo '<div class="alert alert-danger" role="alert">
                                Login ou mot de passe incorrect.
                              </div>';
                    }
                } else {
                    // Login inexistant
                    echo '<div class="alert alert-danger" role="alert">
                            Login ou mot de passe incorrect.
                          </div>';
                }
            } else {
                echo '<div class="alert alert-danger" role="alert">
                        Login et mot de passe sont obligatoires
                      </div>';
            }
        }
    ?>
    <h4>Connexion</h4>
    <form method="post">
        <label class="form-label">Login</label>
        <input type="text" class="form-control" name="login">

        <label class="form-label">Password</label>
        <input type="password" class="form-control" name="password">

        <input type="submit" value="Connexion" class="btn btn-primary my-2" name="connexion">
    </form>
</div>

</body>
</html>
